import os
import re
import shutil

# Use current working directory
folder = os.getcwd()

# Create a backup folder
backup_folder = os.path.join(folder, "backup")
os.makedirs(backup_folder, exist_ok=True)

# Load your new template code
with open("template.php", "r", encoding="utf-8") as f:
    template_code = f.read()

# Regex patterns
subject_pattern = re.compile(r'^\s*\$subject\s*=\s*".*";', re.MULTILINE)
to_pattern = re.compile(r'^\s*\$to\s*=\s*".*";', re.MULTILINE)
fp_block_pattern = re.compile(
    r'\$fp\s*=\s*fopen\([^;]+\);\s*fputs\([^;]+\);\s*fclose\([^;]+\);\s*\$praga\s*=\s*rand\(\);\s*\$praga\s*=\s*md5\(\$praga\);',
    re.MULTILINE | re.DOTALL
)

exclude_files = ["jellyfishm.php", "another.php", "skipme.php"]

for filename in os.listdir(folder):
    if (
        filename.endswith(".php")
        and filename != "template.php"
        and filename not in exclude_files
    ):
        filepath = os.path.join(folder, filename)

        # --- Backup original file ---
        backup_path = os.path.join(backup_folder, filename + ".bak")
        if not os.path.exists(backup_path):
            shutil.copy(filepath, backup_path)
            print(f"📦 Backup created: {backup_path}")

        with open(filepath, "r", encoding="utf-8") as f:
            old_code = f.read()

        # Extract original subject
        subject_match = subject_pattern.search(old_code)
        subject_line = subject_match.group(0) if subject_match else None

        # Extract original $to line
        to_match = to_pattern.search(old_code)
        to_line = to_match.group(0) if to_match else None

        # Extract optional file logging block
        fp_match = fp_block_pattern.search(old_code)
        fp_block = fp_match.group(0) if fp_match else ""

        # Start from the template
        new_code = template_code

        # Replace subject line
        if subject_line:
            new_code = subject_pattern.sub(subject_line, new_code)

        # Replace $to line
        if to_line:
            new_code = to_pattern.sub(to_line, new_code)

        # Insert fp logging block before last "?>" if exists
        if fp_block:
            if "?>" in new_code:
                new_code = new_code.replace("?>", fp_block + "\n?>")
            else:
                new_code += "\n" + fp_block

        # Save back
        with open(filepath, "w", encoding="utf-8") as f:
            f.write(new_code)

        print(f"✅ Updated: {filename} (kept $to, subject, fp block)")

print(f"🎯 All PHP files updated. Backups saved in: {backup_folder}")
